#Created by George Bargoud

from os      import path
from csv     import reader, writer
from Tkinter import Frame, Tk, Listbox, OptionMenu, Entry, StringVar, Label, Button, IntVar

class ScheduleEditor(Frame):
    def __init__(self, master=None):
        Frame.__init__(self,master,relief='solid')
        
        #place the courses in a dictionary from the day of the week to the course
        self.getCourses()
        
        topFrame = Frame(master=self)
        self.day = StringVar(value=self.days[0])
        
        Label(topFrame,text='_'*100).pack(side='top',anchor='n')
        Label(topFrame,text='Schedule Editor').pack(side='top',anchor='n')
        daysOfWeek = OptionMenu(topFrame,self.day,*self.days,command=self.display)
        daysOfWeek.pack()
        topFrame.pack(side='top', anchor='n')
        
        editFrame = Frame(master=self)
        Label(editFrame,text="Add Course").pack(side='top',anchor='w')
        self.name = StringVar(value='Course Name')
        Entry(editFrame,width='11',textvariable=self.name).pack(side='left',anchor='w')
        Label(editFrame,text="from").pack(side='left',anchor='w')
        self.startHour = StringVar(value='00')
        Entry(editFrame,width='2',textvariable=self.startHour).pack(side='left',anchor='w')
        Label(editFrame,text=":").pack(side='left',anchor='w')
        self.startMinute = StringVar(value='00')
        Entry(editFrame,width='2',textvariable=self.startMinute).pack(side='left',anchor='w')
        Label(editFrame,text="to").pack(side='left',anchor='w')
        self.endHour = StringVar(value='00')
        Entry(editFrame,width='2',textvariable=self.endHour).pack(side='left',anchor='w')
        Label(editFrame,text=":").pack(side='left',anchor='w')
        self.endMinute = StringVar(value='00')
        Entry(editFrame,width='2',textvariable=self.endMinute).pack(side='left',anchor='w')
        Button(editFrame,text='Add Course',command=self.addCourse).pack(side='right',anchor='s')
        editFrame.pack(side='top')
        
        self.courseFrame = Frame(master=self)
        self.coursesList = Listbox(self.courseFrame,width='30')
        self.display()
        buttonFrame = Frame(master=self.courseFrame)
        Button(buttonFrame,text='Delete Selected',command=self.deleteSelected).pack(side='top',anchor='w')
        Button(buttonFrame,text='Delete All For Day',command=self.deleteDay).pack(side='top',anchor='w')
        Button(buttonFrame,text='Delete All',command=self.deleteAll).pack(side='top',anchor='w')
        buttonFrame.pack(padx=20,side='right',anchor='e')
        
        
        Button(self,text="Save Schedule",command=self.save).pack(side='bottom',anchor='s',pady=10)
                
    def display(self, wkday=None):
        self.coursesList.delete(0,10)
        for course in self.courses[self.day.get()]:
            i=0
            self.coursesList.insert(i, course[0] + ' from ' + str(course[1]) + ':' + str(course[2]) + " to " + str(course[3]) + ':' + str(course[4]))
            i += 1
        self.coursesList.pack(side='left',anchor='w')
        self.courseFrame.pack(pady=20)
        
    def getCourses(self):
        #if schedule.csv does not exist, make it as a blank file.
        if(not path.isfile(path.abspath("schedule.csv"))):
            fp = open(path.abspath("schedule.csv"), "w")
            fp.close
        file = open(path.abspath("schedule.csv"), "r")
        coursesRaw = reader(file)
        self.days = ["Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"]
        self.courses = {}
        for day in self.days:
            self.courses[day] = []
        for course in coursesRaw:
            self.courses[self.days[int(course[0])]].append(course[1:6])
        file.close()
            
    def addCourse(self):
        self.courses[self.day.get()].append([self.name.get(),
                                             self.startHour.get(),self.startMinute.get(),
                                             self.endHour.get(),self.endMinute.get()])
        self.display()
        
    def save(self):
        file = open(path.abspath("schedule.csv"), "w")
        save = writer(file)
        for i in range(6):
            for course in self.courses[self.days[i]]:
                save.writerow([i,course[0],course[1],course[2],course[3],course[4]])
        file.close()
        
    def deleteSelected(self):
        selected = self.coursesList.selection_get()
        sel = self.parseCourse(selected)
        self.courses[self.day.get()].remove(sel)
        self.display()
    
    def parseCourse(self,strcourse):
        splcourse = [strcourse.split(' from ')[0],
                     strcourse.split(' from ')[1].split(' to ')[0],
                     strcourse.split(' from ')[1].split(' to ')[1]]
        startTime = splcourse[1].split(':')
        endTime = splcourse[2].split(':')
        fincourse = [splcourse[0],startTime[0],startTime[1],endTime[0],endTime[1]]
        return fincourse
        
    def deleteAll(self):
        self.days = ["Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"]
        self.courses = {}
        for day in self.days:
            self.courses[day] = []
        self.display()
    
    def deleteDay(self):
        self.courses[self.day.get()] = []
        self.display()
    
def schedMain():
    schedRoot = Tk()
    ScheduleEditor(schedRoot).pack()
    schedRoot.mainloop()
    
if __name__=='__main__':
    schedMain()